export const transitionsDirective = () => {
    const scope = {
        model: '='
    };

    const link = ($scope) => {
        "use strict";
        $scope.transitions = {

            "attention_seekers": [
                "bounce",
                "flash",
                "pulse",
                "rubberBand",
                "shake",
                "headShake",
                "swing",
                "tada",
                "wobble",
                "jello"
            ],

            "bouncing_entrances": [
                "bounceIn",
                "bounceInDown",
                "bounceInLeft",
                "bounceInRight",
                "bounceInUp"
            ],

            "bouncing_exits": [
                "bounceOut",
                "bounceOutDown",
                "bounceOutLeft",
                "bounceOutRight",
                "bounceOutUp"
            ],

            "fading_entrances": [
                "fadeIn",
                "fadeInDown",
                "fadeInDownBig",
                "fadeInLeft",
                "fadeInLeftBig",
                "fadeInRight",
                "fadeInRightBig",
                "fadeInUp",
                "fadeInUpBig"
            ],

            "fading_exits": [
                "fadeOut",
                "fadeOutDown",
                "fadeOutDownBig",
                "fadeOutLeft",
                "fadeOutLeftBig",
                "fadeOutRight",
                "fadeOutRightBig",
                "fadeOutUp",
                "fadeOutUpBig"
            ],

            "flippers": [
                "flip",
                "flipInX",
                "flipInY",
                "flipOutX",
                "flipOutY"
            ],

            "lightspeed": [
                "lightSpeedIn",
                "lightSpeedOut"
            ],

            "rotating_entrances": [
                "rotateIn",
                "rotateInDownLeft",
                "rotateInDownRight",
                "rotateInUpLeft",
                "rotateInUpRight"
            ],

            "rotating_exits": [
                "rotateOut",
                "rotateOutDownLeft",
                "rotateOutDownRight",
                "rotateOutUpLeft",
                "rotateOutUpRight"
            ],

            "specials": [
                "hinge",
                "rollIn",
                "rollOut"
            ],

            "zooming_entrances": [
                "zoomIn",
                "zoomInDown",
                "zoomInLeft",
                "zoomInRight",
                "zoomInUp"
            ],

            "zooming_exits": [
                "zoomOut",
                "zoomOutDown",
                "zoomOutLeft",
                "zoomOutRight",
                "zoomOutUp"
            ],

            "sliding_entrances": [
                "slideInDown",
                "slideInLeft",
                "slideInRight",
                "slideInUp"
            ],

            "sliding_exits": [
                "slideOutDown",
                "slideOutLeft",
                "slideOutRight",
                "slideOutUp"
            ]
        }

    };

    return {
        restrict: 'E',
        link: link,
        scope: scope,
        templateUrl: 'transitions/transitions.directive.html'
    }
};